# include "includes.h"

/****************************************************************************//*
NEWZVEL.c:

This is a program replacing the old conservation calculation algorithm based on
that of zvelebil et al.   Better handling of the data here should speed up the 
program and allow exclusion of atypical sequence data which destroys sequence 
conservation at a given alignment position.

Variables passed to the program are:

zv:	dynamically allocated integer variable of dimension 1 by count+3
        used to pass conservation values for each alignment position back to 
        "main"
bloc:	Structure containing sequence alignment information in standard AMPS 
        format.
no:	number of sequences in group being analysed.
inx:	index relating numbers from 1 -> no to sequences in the blocfile
count:	the length of the alignment in residues from 1 -> count
ptype:	structure containing property matrix information
gcut:	number of gaps to be ignored in a group before a position is deemed
        unconserved
neg:	set to 0 if only positive properties are to be considered, otherwise 1
point:	maximum number of conserved properties.
        set to ptype.pno when neg is 1, otherwise set to the maximum number of 
        mutually held properties for a particular matrix
nbloc:	number of sequences in the bloc structure.

****Modified****

This program was radically re-modelled and vastly simplified on Dec 15th 1992

*//****************************************************************************/

void zvel(zv,bloc,no,inx,count,ptype,gcut,neg,
          point,nbloc,atyp,rcont,rN,resipos,clustno,consval)
int count,no,*inx,gcut,neg,point,nbloc,*zv,atyp,rcont,clustno,consval;
char **rN;
struct slist ptype;
struct seqdat *bloc;
struct resisto *resipos;
{

  int mn,mu,mx,ml,my,gres,gsto,ngp,rngc;
  int *npos,*increment,nng,alt;
  int foundsy,sru,integrate,posp,negp,nrt,toomany=0;
  int improve,zvsto,zvnew,atyptotal=0,posto;
  char *atypchars;

  atypchars = (char*) malloc (sizeof(char)*(ptype.syno+1));
  increment = (int*) malloc (sizeof(int)*(ptype.pno+3));
  npos = (int*) malloc(sizeof(int)*(ptype.syno+1));



  for(ml=1;ml<count+1;++ml){
    ngp=0;alt=0;
    for(mu=1;mu<no+1;++mu) if(bloc[inx[mu]].seq[ml]==' ')ngp++;
    if(ngp<no){


    for(mu=0;mu<ptype.syno+1;++mu)npos[mu]=0; 	/* No. positives for a resi */
 /****************************************************************************//*
	1. Determine the number of each symbol present in the group including
	   GAPS. Abort the program if a symbol is not found (?)     ^^^^^^^^^
*//****************************************************************************/
  
    foundsy=0;  				/* symbol found flag */
    for(mu=1;mu<no+1;++mu){			/* 1 to no. seqs in subgroup */
      for(mn=0;mn<ptype.syno;++mn){		/* 0 to no. ptype symbols */
        if(ptype.aas[mn]==' ')gres=mn;		/* store aas no. of ' ' */
        if(ptype.aas[mn]==bloc[inx[mu]].seq[ml]){	/* if aas char==resi */
          npos[mn]++;				/* increment no. of resi type */
          foundsy++;				/* record resi found */
        }
      }
      if(foundsy==0){            		/* if resi not found...*/
        printf("\n\nError: Amino Acid"); 
        printf(  " Symbol \"%c\" not found\n",bloc[inx[mu]].seq[ml]);
        exit(0);
      }
    }


/****************************************************************************//*
	2. Determine the number of residue types including gaps
						 ^^^^^^^^^
*//****************************************************************************/

    nrt=0;nng=0;				/* number of residue types */
    for(mn=0;mn<ptype.syno;++mn){
      if(npos[mn]!=0)nrt++;
      if((npos[mn]!=0)&&(ptype.aas[mn]!=' '))nng++; /* number not gap */
    }

/****************************************************************************//*
	3. Check which residues (if any) are to be ignored and ignore them! 
*//****************************************************************************/

    if((atyp>0)&&(rcont==1)){
      atyptotal=0;toomany=0;
      for(mx=0;mx<ptype.syno;++mx)rN[ml][mx]=0; /* wipe ignored resi. list */
      for(mx=0;mx<ptype.syno;++mx){             /* scan ptype table */

        if(npos[mx]>0){ 			/* if a resi. type occurs */

          rN[ml][mx]=10;                        /* record resi present */

          if((atyp>(npos[mx]*100)/no)&& 	/* if atyp percent is >
						   percentage resi of all resis
						   at the posn. */
            (toomany==0)){			/* if max percent resis ignored
						/* not breeched */

            if(ptype.aas[mx]!=' '){
              rN[ml][mx]=1;			/* place resi on ignored list */
              nrt--;
              alt++;   				/* record no. atyp types */
						/* ignored */
            }		 
            atyptotal = atyptotal + npos[mx];   /* increment atyp total by
						   number of resis of type */


 /* should this include gap?  this is orig. pos */


            if((atyptotal>0)&&
               (no/atyptotal<100/atyp))toomany=1;
             
          }   
        }
      }
    }

    if(rcont==2){
      for(my=0;my<ptype.syno;++my)
        if(rN[ml][my]==1){
          nrt--;
        }
    }

/****************************************************************************//*
	4. remove gap ignore number gcut from number of gaps if 1st round
*//****************************************************************************/

    if(rcont==1){
      gsto = npos[gres];
      npos[gres]=npos[gres]-gcut;
      if(npos[gres]<0)npos[gres]=0;
      if((gsto>0)&&(npos[gres]<=0)){
      /*  alt++; */			/* include gap in the non conserved */ 
					/* calcualtion */
        rN[ml][gres]=1;
        nrt--;
      }
    }

/****************************************************************************//*
	5. Calculate conservation values *//****************************************************************************/

    rngc=0;						/* system to prevent  */
    for(mn=0;mn<ptype.syno;++mn){			/* positions at which */
      if(mn!=gres){					/* only gap is        */
        if((npos[mn]>0)&&(rN[ml][mn]!=1))rngc++; 	/* considered from    */
      }							/* being reported     */
    }							/* conserved see zz   */
					/* rngc = residues not gap considered */
    posto=0;       
    if(nrt>0){ 	
      for(mu=0;mu<ptype.pno;++mu)increment[mu]=0;	
      for(mn=0;mn<ptype.syno;++mn){
        if(rN[ml][mn]==1)mn++;
        if(npos[mn]!=0){
          if(rcont==1){
            resipos[ml].resiclust[clustno][posto]=ptype.aas[mn];
            posto++;
          }
          for(mu=0;mu<ptype.pno;++mu)         
            if(ptype.apm[mu].ptype[mn]==1)increment[mu]++; 
            
        }
      }
/*      printf("%d,%d:  %s \n",ml,clustno,resipos[ml].resiclust[clustno]);*/
      integrate=0;
      for(mu=0;mu<ptype.pno;++mu){
        if((neg==1)&&                            
           (increment[mu]!=0)&&			 
           (increment[mu]!=nrt))integrate++;
        if((neg==0)&&(increment[mu]!=nrt))integrate++;
      }      
      if(integrate>ptype.pno)integrate=ptype.pno-1; /*???*/
      zvsto=(ptype.pno)-integrate;
      if(zvsto==0)zvsto=-1;
      if((zvsto>=point)&&(nng==1)&&(alt==0))zvsto++; 
      if((nrt==1)&&(nng==0))zvsto=0;   
      zv[ml]=zvsto;
      if(rngc==0)zv[ml]=0;				/* this is zz */
    } else zv[ml]=-1;
    } else zv[ml]=-1;
  }
  free(atypchars);
  free((char*) increment);
  free((char*) npos);
}
