# include "includes.h"

/****************************************************************************//*
    Report Conserved Positions ...
*//****************************************************************************/

void consrep(noclust,count,same,diff,point,ptype,
             cl,bloc,simname,intcons,consval,resipos)
int **same,**diff,**intcons;
int count,consval,noclust,point;
struct slist ptype;
struct indclust *cl;
struct seqdat *bloc;
struct resisto *resipos;
char *simname;
{
  FILE *sim; 
  int  ml,mx,mn,mz,mu,my,qx,qy,qz,cm,ct,cx,cy;
  int  aa,tally,ngaps,tsp,rchrlen,numbs,sto,oy,posto,msto;
  int  **cc,**cp,*cd,**done;
  char *er,comb;

  er = (char*) malloc(sizeof(char)*(ptype.pno+2)); 
  cc=(int**) malloc(sizeof(int*)*(noclust+1));
  cd = (int*) malloc(sizeof(int)*(ptype.syno+1));
  for(mn=1;mn<noclust+1;++mn)
    cc[mn] = (int*) malloc(sizeof(int)*(ptype.syno+1));
  cp=(int**) malloc(sizeof(int*)*(noclust+1));
  for(mn=1;mn<noclust+1;++mn)
    cp[mn] = (int*) malloc(sizeof(int)*(ptype.pno+1));

  aa=0;
  for(mn=1;mn<noclust;++mn)
    for(ml=mn+1;ml<noclust+1;++ml)aa++;


  done=(int**) malloc(sizeof(int*) *(count+1));
  for(mu=0;mu<count+1;++mu){
    done[mu] = (int*) malloc(sizeof(int)*(noclust+1));
    for(mn=0;mn<noclust+1;++mn)done[mu][mn]=-1;
  }

  if((sim=fopen(simname,"a"))==NULL){
    printf("Error: cant open file %s\n",simname);
    exit(0);
  } 

  fprintf(sim,"******************\n");
  fprintf(sim,"*2* CONSERVATION *\n");
  fprintf(sim,"******************\n\n");



/****************************************************************************//*
    Report Conserved Alignment Positions ...
*//****************************************************************************/

  ngaps = 5 * noclust;
  fprintf(sim,"* Conservation between all sub-groups\n");
  tally=0;
  for(ml=1;ml<count+1;++ml){
    cm=0;ct=0;tsp=0;
    for(mn=0;mn<aa;++mn){
      if(same[mn][ml]>0) cm++;		/* Identify conserved sub-group pairs */
      if(same[mn][ml]==point+1) ct++;}  /* identify identical sub-group pairs */
    if((cm==aa)&&(ct<aa)){
      for(mx=0;mx<noclust+1;++mx)done[ml][mx]=1;
      fprintf(sim,"\n(%3d) ALL (",ml);	/* identify the position number	    */
      tally++;
      for(mn=0;mn<aa;++mn){
        if(same[mn][ml]<=point){my=same[mn][ml];}else my=point;
        if(mn<aa-1){
          fprintf(sim,"%2d,",my);	/* record sub-group pair */
        } else fprintf(sim,"%2d)",my);} /* conservation numbers  */
      for(qy=0;qy<ptype.syno;++qy)cd[qy]=0;
      for(cx=1;cx<noclust+1;++cx){
        if(cx<27){fprintf(sim,"  %c-[",cx+64);} /* identify each sub-group */
        else { fprintf(sim," %2d-[",cx-26);}   


        for(qy=0;qy<ptype.syno;++qy)cc[cx][qy]=0;
        rchrlen=0;
        msto=0;posto=0;
        while(resipos[ml].resiclust[cx][posto]!='\0')posto++;
        msto=posto;
        for(posto=0;posto<msto;++posto){
          qy=0;
          while((qy<ptype.syno)&&		 
                (ptype.aas[qy]!=
                 resipos[ml].resiclust[cx][posto])) 
       		qy++; 
          if(ptype.aas[qy]!=' '){
            fprintf(sim,"%c",ptype.aas[qy]);
            rchrlen++;
          } else {
            fprintf(sim,"_");
            rchrlen++;
          }
          cd[qy]++;
        }
        fprintf(sim,"]");
        tsp=tsp+rchrlen;
        for(qx=1;qx<cl[cx].number+1;++qx){ 
          qy=0;
          while((qy<ptype.syno)&& 
                (ptype.aas[qy]!=
                 bloc[cl[cx].order[qx]].seq[ml])) 
       		qy++; 
          cc[cx][qy]++;
        }
      }
      numbs=0;
      for(qy=0;qy<ptype.pno;++qy)er[qy]=0;
      for(qy=0;qy<ptype.syno;++qy)
        if(cd[qy]>0){ 
          numbs++;
          for(qz=0;qz<ptype.pno;++qz) 
            if(ptype.apm[qz].ptype[qy]==1)er[qz]++;}
      for(cx=1;cx<noclust+1;++cx)
        for(qz=0;qz<ptype.pno;++qz)cp[cx][qz]=0;

      for(cx=1;cx<noclust+1;++cx)
        for(qy=0;qy<ptype.syno;++qy)
          if(cc[cx][qy]>0){ 
            for(qz=0;qz<ptype.pno;++qz) 
              if(ptype.apm[qz].ptype[qy]==1)cp[cx][qz]=cp[cx][qz]+cc[cx][qy];
          }
      qz=0;qy=0;qx=0;
      while((qy<ptype.pno)||(qz<ptype.pno)){

/* List conserved properties */

        while((qy<ptype.pno)&&(er[qy]!=numbs)&&(qy<ptype.pno))qy++; 
        if(qy<ptype.pno){  
          if(qx==0){
            for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
            fprintf(sim," Cons: ");
            fprintf(sim,"%-14s",ptype.pnames[qy]);
          } else {
            fprintf(sim,"            ");
            for(my=0;my<noclust;++my)fprintf(sim,"      ");
             for(my=0;my<aa;++my)fprintf(sim,"   ");
            for(my=0;my<ngaps;++my)fprintf(sim," ");
            fprintf(sim,"      ");
            fprintf(sim,"%-14s",ptype.pnames[qy]);
          }
          qy++;
        } else if(qx!=0){
            fprintf(sim,"            ");
            for(my=0;my<noclust;++my)fprintf(sim,"      ");
            for(my=0;my<aa;++my)fprintf(sim,"   ");
            for(my=0;my<ngaps;++my)fprintf(sim," ");
            fprintf(sim,"      ");
            fprintf(sim,"%-14s"," ");
        } else {
          for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
          fprintf(sim," Cons: ");
          fprintf(sim,"%-14s"," ");
        }

        /* List different properties */

        while( (qz<ptype.pno)&&((er[qz]==numbs)||(er[qz]==0)))qz++;
        if(qz<ptype.pno){  
          if(qx==0){fprintf(sim," Diff: ");}
          else      fprintf(sim,"       ");
          fprintf(sim,"%-14s",ptype.pnames[qz]);
          for(cx=1;cx<noclust+1;++cx){
            if(cx<27){fprintf(sim," %c-[",cx+64);}
            else { fprintf(sim,"%2d-[",cx-26);}
            fprintf(sim,"%3d%%",(cp[cx][qz]*100)/cl[cx].number);
            fprintf(sim,"] ");
          }
          fprintf(sim,"\n");
          qz++;
        } else if(qx==0){
          fprintf(sim," Diff: \n");
        } else fprintf(sim,"\n");
        qx=1;
      }
    }
  }



  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");



/****************************************************************************//*
    Report Conserved Sub-group Pair Positions ...
*//****************************************************************************/

  fprintf(sim,"* Conservation between sub-group pairs\n");

  tally=0;sto=0;ngaps = 10;

  for(ml=1;ml<count+1;++ml){
    cm=0;
    for(oy=0;oy<aa;++oy)if(same[oy][ml]>0)cm++;
    if(cm<aa){
      mn=-1;
      for(cx=1;cx<noclust;++cx)
        for(cy=cx+1;cy<noclust+1;++cy){
          mn++;tsp=0;
          if((same[mn][ml]>0)&&(same[mn][ml]<point+1)){
            if(sto!=ml){
              fprintf(sim,"\n(%3d) ",ml);
              sto=ml;tally++;
            }else fprintf(sim,"      ");
            done[ml][cx]=1;done[ml][cy]=1;
            if(same[mn][ml]<=point){my=same[mn][ml];}else my=point;
            if(cx<27){fprintf(sim,"  %c,",cx+64);}
            else { fprintf(sim," %2d,",cx-26);}
            if(cy<27){fprintf(sim,"%c  (%2d) ",cy+64,my);}
            else { fprintf(sim,"%-2d (%2d) ",cy-26,my);}
	    oy=cx;
            for(qy=0;qy<ptype.syno;++qy)cd[qy]=0;
	    for(my=0;my<2;++my){ 
              if(oy<27){fprintf(sim,"  %c-[",oy+64);} 
              else { fprintf(sim," %2d-[",oy-26);}  
              for(qy=0;qy<ptype.syno;++qy)cc[oy][qy]=0;
              rchrlen = 0;           
              msto=0;posto=0;
              while(resipos[ml].resiclust[oy][posto]!='\0')posto++;
              msto=posto;
              for(posto=0;posto<msto;++posto){
                qy=0;
                while((qy<ptype.syno)&&		 
                      (ptype.aas[qy]!=
                       resipos[ml].resiclust[oy][posto])) 
       		       qy++;				    
                if(ptype.aas[qy]!=' '){
                  fprintf(sim,"%c",ptype.aas[qy]);
                  rchrlen++;
                } else {
                  fprintf(sim,"_");
                  rchrlen++;
                }
                cd[qy]++;
              }
              fprintf(sim,"]");
              tsp=tsp+rchrlen;
              for(qx=1;qx<cl[oy].number+1;++qx){ 
                qy=0;
                while((qy<ptype.syno)&& 
                      (ptype.aas[qy]!=
                       bloc[cl[oy].order[qx]].seq[ml])) 
       		      qy++; 
                cc[oy][qy]++;
              }
              oy=cy;
            }
			
            numbs=0;
            for(qy=0;qy<ptype.pno;++qy)er[qy]=0;
            for(qy=0;qy<ptype.syno;++qy)
              if(cd[qy]>0){ 
                numbs++;
                for(qz=0;qz<ptype.pno;++qz) 
                  if(ptype.apm[qz].ptype[qy]==1)er[qz]++;}

            for(qz=0;qz<ptype.pno;++qz){cp[cx][qz]=0;cp[cy][qz]=0;}

            for(qy=0;qy<ptype.syno;++qy){
              if(cc[cx][qy]>0){ 
                for(qz=0;qz<ptype.pno;++qz) 
                  if(ptype.apm[qz].ptype[qy]==1)
                    cp[cx][qz]=cp[cx][qz]+cc[cx][qy];}
              if(cc[cy][qy]>0){ 
                for(qz=0;qz<ptype.pno;++qz) 
                  if(ptype.apm[qz].ptype[qy]==1)
                    cp[cy][qz]=cp[cy][qz]+cc[cy][qy];}
            }


/* List conserved properties */
 
            qz=0;qy=0;qx=0;
            while((qy<ptype.pno)||(qz<ptype.pno)){
              while((qy<ptype.pno)&&(er[qy]!=numbs)&&(qy<ptype.pno))qy++; 
              if(qy<ptype.pno){  
                if(qx==0){
                  for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
                  fprintf(sim," Cons: ");
                  fprintf(sim,"%-14s",ptype.pnames[qy]);
                } else {
                  fprintf(sim,"       ");
                  for(my=0;my<2;++my)fprintf(sim,"         ");
                  for(my=0;my<ngaps;++my)fprintf(sim," ");
                  fprintf(sim,"            ");
                  fprintf(sim,"%-14s",ptype.pnames[qy]);
                }
                qy++;
                } else if(qx!=0){
                  fprintf(sim,"            ");
                  for(my=0;my<2;++my)fprintf(sim,"         ");
                  for(my=0;my<ngaps;++my)fprintf(sim," ");
                  fprintf(sim,"       ");
                  fprintf(sim,"%-14s"," ");
              } else {
                for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
                fprintf(sim," Cons: ");
                fprintf(sim,"%-14s"," ");
              }

        /* List different properties */

              while( (qz<ptype.pno)&&((er[qz]==numbs)||(er[qz]==0)))qz++;
              if(qz<ptype.pno){  
                if(qx==0){fprintf(sim," Diff: ");}
                else      fprintf(sim,"       ");
                fprintf(sim,"%-14s",ptype.pnames[qz]);


                if(cx<27){fprintf(sim," %c-[",cx+64);}
                else { fprintf(sim,"%2d-[",cx-26);}
                fprintf(sim,"%3d%%",(cp[cx][qz]*100)/cl[cx].number);
                fprintf(sim,"] ");
                if(cy<27){fprintf(sim," %c-[",cy+64);}
                else { fprintf(sim,"%2d-[",cy-26);}
                fprintf(sim,"%3d%%",(cp[cy][qz]*100)/cl[cy].number);
                fprintf(sim,"] ");
            
                fprintf(sim,"\n");
                qz++;
              } else if(qx==0){
                fprintf(sim,"    Diff: \n");
              } else fprintf(sim,"\n");
              qx=1;
            }
     }}}}
 
  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");



/****************************************************************************//*
    Report Different Sub-group Pair Positions ...
*//****************************************************************************/

  fprintf(sim,"* Difference between sub-group pairs\n");

  tally=0;sto=0;ngaps = 10;

  for(ml=1;ml<count+1;++ml){
    cm=0;
    mn=-1;
    for(cx=1;cx<noclust;++cx)
      for(cy=cx+1;cy<noclust+1;++cy){
        mn++;tsp=0;
        if(diff[mn][ml]>0){
          if(sto!=ml){
            fprintf(sim,"\n(%3d) ",ml);
            sto=ml;tally++;
          }else fprintf(sim,"      ");	
          my=diff[mn][ml];
          done[ml][cx]=1;done[ml][cy]=1;
          if(cx<27){fprintf(sim,"  %c,",cx+64);}
          else { fprintf(sim," %2d,",cx-26);}
          if(cy<27){fprintf(sim,"%c  (%2d) ",cy+64,diff[mn][ml]);}
          else { fprintf(sim,"%-2d (%2d) ",cy-26,diff[mn][ml]);}    
          oy=cx;
          for(qy=0;qy<ptype.syno;++qy)cd[qy]=0;
          for(my=0;my<2;++my){ 
            if(oy<27){fprintf(sim,"  %c-[",oy+64);} 
            else { fprintf(sim," %2d-[",oy-26);}         
            for(qy=0;qy<ptype.syno;++qy)cc[oy][qy]=0;
            rchrlen = 0;    
            msto=0;posto=0;
            while(resipos[ml].resiclust[oy][posto]!='\0')posto++;
            msto=posto;
            for(posto=0;posto<msto;++posto){
              qy=0;
              while((qy<ptype.syno)&& 
                    (ptype.aas[qy]!=
                     resipos[ml].resiclust[oy][posto]))
       		     qy++;
              if(ptype.aas[qy]!=' '){
                fprintf(sim,"%c",ptype.aas[qy]);
                rchrlen++;
              } else {
                fprintf(sim,"_");
                rchrlen++;
              }
              cd[qy]++;
            }
            fprintf(sim,"]");
            tsp=tsp+rchrlen;
            for(qx=1;qx<cl[oy].number+1;++qx){ 
              qy=0;
              while((qy<ptype.syno)&& 
                    (ptype.aas[qy]!=
                     bloc[cl[oy].order[qx]].seq[ml])) 
                     qy++; 
              cc[oy][qy]++;
            }
            oy=cy;
          }
	   
        numbs=0;
        for(qy=0;qy<ptype.pno;++qy)er[qy]=0;
        for(qy=0;qy<ptype.syno;++qy)
          if(cd[qy]>0){ 
            numbs++;
            for(qz=0;qz<ptype.pno;++qz) 
              if(ptype.apm[qz].ptype[qy]==1)er[qz]++;}
        for(qz=0;qz<ptype.pno;++qz){cp[cx][qz]=0;cp[cy][qz]=0;}
        for( qy=0;qy<ptype.syno;++qy){
          if(cc[cx][qy]>0){ 
            for(qz=0;qz<ptype.pno;++qz) 
              if(ptype.apm[qz].ptype[qy]==1)
                cp[cx][qz]=cp[cx][qz]+cc[cx][qy];}
          if(cc[cy][qy]>0){ 
            for(qz=0;qz<ptype.pno;++qz) 
              if(ptype.apm[qz].ptype[qy]==1)
                cp[cy][qz]=cp[cy][qz]+cc[cy][qy];}
        }


/* List conserved properties */
 
        qz=0;qy=0;qx=0;
        while((qy<ptype.pno)||(qz<ptype.pno)){
          while((qy<ptype.pno)&&(er[qy]!=numbs)&&(qy<ptype.pno))qy++; 
          if(qy<ptype.pno){  
            if(qx==0){
              for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
              fprintf(sim," Cons: ");
              fprintf(sim,"%-14s",ptype.pnames[qy]);
            } else {
              fprintf(sim,"            ");
              for(my=0;my<2;++my)fprintf(sim,"         ");
              for(my=0;my<ngaps;++my)fprintf(sim," ");
              fprintf(sim,"       ");
              fprintf(sim,"%-14s",ptype.pnames[qy]);
            }
            qy++;
          } else if(qx!=0){
            fprintf(sim,"            ");
            for(my=0;my<2;++my)fprintf(sim,"         ");
            for(my=0;my<ngaps;++my)fprintf(sim," ");
            fprintf(sim,"       ");
            fprintf(sim,"%-14s"," ");
          } else {
            for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
            fprintf(sim," Cons: ");
            fprintf(sim,"%-14s"," ");
          }

        /* List different properties */

          while( (qz<ptype.pno)&&((er[qz]==numbs)||(er[qz]==0)))qz++;
          if(qz<ptype.pno){  
            if(qx==0){fprintf(sim," Diff: ");}
            else      fprintf(sim,"       ");
            fprintf(sim,"%-14s ",ptype.pnames[qz]);
            if(cx<27){fprintf(sim," %c-[",cx+64);}
            else { fprintf(sim,"%2d-[",cx-26);}
            fprintf(sim,"%3d%%",(cp[cx][qz]*100)/cl[cx].number);
            fprintf(sim,"] ");



            if(cy<27){fprintf(sim," %c-[",cy+64);}
            else { fprintf(sim,"%2d-[",cy-26);}
            fprintf(sim,"%3d%%",(cp[cy][qz]*100)/cl[cy].number);
            fprintf(sim,"] ");
            fprintf(sim,"\n");
            qz++;
          } else if(qx==0){
            fprintf(sim,"    Diff: \n");
          } else fprintf(sim,"\n");
          qx=1;
        }
      }
    }
  }
 
  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");


/****************************************************************************//*
    Report Conserved Individual Sub-group Positions ...
*//****************************************************************************/

  fprintf(sim,"* Conserved within one sub-group\n");
  sto=0;ngaps=10;tally=0;
  for(ml=1;ml<count+1;++ml){ 
    for(cx=1;cx<noclust+1;++cx){
      tsp=0;
      if(done[ml][cx]==-1){
        if((intcons[cx][ml]>=consval)&&(intcons[cx][ml]<point+1)){
          if(sto!=ml){
            fprintf(sim,"\n(%3d)",ml);
            sto=ml;
          }
          tally++;


          if(cx<27){fprintf(sim,"  %c  ",cx+64);}
          else { fprintf(sim," %2d  ",cx-26);}




          fprintf(sim,"(%2d)",intcons[cx][ml]);

          if(cx<27){fprintf(sim,"   %c-",cx+64);}
          else { fprintf(sim,"  %2d-",cx-26);}

          fprintf(sim,"[");
          for(qx=0;qx<ptype.syno+1;++qx)cd[qx]=0;

          msto=0;posto=0;
          while(resipos[ml].resiclust[cx][posto]!='\0')posto++;
          msto=posto;
          for(posto=0;posto<msto;++posto){

            qy=0;rchrlen=0;

            while((qy<ptype.syno)&& 
                  (ptype.aas[qy]!=
                   resipos[ml].resiclust[cx][posto]))
       		   qy++;

            comb=ptype.aas[qy];
            if(comb==' ')comb = '_';
            if(cd[qy]==0){
              fprintf(sim,"%c",comb);
              rchrlen++;
            }
            cd[qy]=1;
          }
          fprintf(sim,"]");
          tsp=tsp+rchrlen;
 
/*calculate conserved properties*/

          numbs=0;
          for(qy=0;qy<ptype.pno;++qy)er[qy]=0;
          for(qy=0;qy<ptype.syno;++qy)
            if(cd[qy]>0){ 
              numbs++;
              for(qz=0;qz<ptype.pno;++qz) 
                if(ptype.apm[qz].ptype[qy]==1)er[qz]++;
             }

          qz=0;qy=0;qx=0;
          while(qy<ptype.pno){
            while((qy<ptype.pno)&&(er[qy]!=numbs)&&(qy<ptype.pno))qy++; 
            if(qy<ptype.pno){  
              if(qx==0){
                for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
                fprintf(sim," Cons: ");
                fprintf(sim,"%-14s",ptype.pnames[qy]);
              } else {
                fprintf(sim,"                    ");
                for(my=0;my<ngaps;++my)fprintf(sim," ");
                fprintf(sim,"           ");
                fprintf(sim,"%-14s",ptype.pnames[qy]);
              }
              qy++;
            }
            fprintf(sim,"\n");
            qx=1;
          }
        }
      } 
    }
  }
  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");


/****************************************************************************//*
    END ...
*//****************************************************************************/

  fclose(sim);

  free((char*) er);

  for(mu=1;mu<noclust+1;++mu)free((char*)cc[mu]); 
  free((char*) cc);

  for(mu=1;mu<noclust+1;++mu)free((char*)cp[mu]); 
  free((char*) cp);
  free((char*) cd);
  for(mu=0;mu<count+1;++mu)free((char*)done[mu]);
  free((char*) done);
}
