#  
#  This is the alscript command file used to create the figure
#  published in:  Roach P. L. et al (1995), Nature (June)
#  
#  The figure shows Isopenicillin N synthase with homologues
#  secondary structure and other information.  It makes use
#  of many features of alscript 2.0
#
#  Comments in the file all start with the # sign
#
#
# define the alignment block file
BLOCK_FILE ipns.blc
# define the output file name
OUTPUT_FILE ipns.ps
# select portrait mode - longest paper side is vertical
PORTRAIT
# select point size for characters - this can be any number.
POINTSIZE 6.5 
#
# Define fonts that we will use in the alignment. You give each font 
# a unique number. The names of the fonts are standard PostScript 
# font names.
#
# This one means call Helvetica at the Default pointsize, font 0
DEFINE_FONT 0 Helvetica DEFAULT
# This means call Helvetica-Oblique at 70% of the default point size, font 1
DEFINE_FONT 1 Helvetica-Oblique REL 0.70
DEFINE_FONT 2 Helvetica-Bold DEFAULT
define_font 5 Symbol REL 1.2
define_font 6 Helvetica REL 0.7
#
# Colour definitions
# 
# Define the colours that we will use in the alignment.  Each colour is given
# a number by which it is referred to later.  The three numbers following
# each colour are red,green,blue intensities.
#
# e.g. this defines colour number 1 to be red (1,0,0).
DEFINE_COLOUR 1 1 0 0
#DEFINE_COLOUR 2 0.8 1 0.8
DEFINE_COLOUR 2 1 1 0
DEFINE_COLOUR 3 0 0 1
DEFINE_COLOUR 4 1 1 1 
DEFINE_COLOUR 5 1 1 1
DEFINE_COLOUR 6 1 0.5 0
DEFINE_COLOUR 7 1 0   1
DEFINE_COLOUR 8 0 0   0
DEFINE_COLOUR 9 1 1   1
define_colour 10 0 1 0
define_colour 11 0 0 0
#
# The add_seq command adds extra space  to the alignment you have read in.
# 
#
# Here we are adding space for four more lines after sequence number 8.
add_seq 8 4
#
# This means don't number the sequences 
no_numbers
#
# Alter the width of the space for identifiers at the lhs of the plot.  This
# must be set by trial and error - 10 is the default.
ident_width 6
#
# Only print sequence identifiers on the first line of a multi-line/page 
# alignment plot.
id_only_on_first_line
#
# This is some fiddling to reduce the default vertical spacing between 
# sequence lines.  We did this to improve the appearance of the alignment
# in a single column of Nature.  Other features of the display can 
# be modified in a similar way - e.g. x_space_factor.
y_space_factor 0.05
#
# commands above the SETUP are about the overall layout etc.  Commands
# after, are giving specific boxing/shading/colouring etc.
#
SETUP
#
# Calcluate conservation values for the complete alignment.  Conservation
# values range from 0-10 where 10 is an identity.  Values above 5 show
# increasing similarities in physico-chemical properties.  Having calculated
# conservation values, we can then colour the plot to highlight conserved
# positions.
#
calcons 1 1 424 8
# 
# set mask for conserved position better than 5
#
# this clears the MASK array of all previous settings
mask SETUP
# this masks all columns of the alignment for which the conservation
# is > 5.
mask CONSERVATION ALL 5
#
# Now we box the masked positions and colour the 
# text backgrounds yellow (colour 2).  Note that this operation could
# be restricted to a subset of the alignment rather than the whole thing.
mask BOX 1 1 424 8
#
# The SCOL command colours the backgrounds of the character.  The CCOL
# command colours the character itself.
mask SCOL 1 1 424 8 2
#
# This resets the MASK commands ready for another operation.  If you don't
# reset, then subsequent mask commands are ADDED to the existing mask
#
mask RESET
#
#now do thw same for identities, only this time in red
#with white lettering
mask CONSERVATION ALL 10
mask SCOL 1 1 424 8 1
mask CCOL 1 1 424 8 99
mask FONT 1 1 424 8 2
mask RESET
#
# sub_id allows the identifier to be modified.  At present it is not possible
# to mix fonts within an ID, but the ID_FONT command can be used to modify the
# font used for individual IDs.
sub_id 1 "ACCO"
sub_id 2 "F3OH"
sub_id 3 "H6H "
sub_id 4 "FOLS"
sub_id 5 "GC20"
sub_id 6 "DAOCS"
sub_id 7 "DAOC/DACS "
sub_id 8 "IPNS"
#
# These are the secondary structure definitions.  They were entered by 
# hand from an analysis of the IPNS structure.
#
# Secondary structure
#
# Set Numbering relative to IPNS
# 
# The x values (sequence position) of any commands that follow a 
# relative_to command will be translated into absolute alignment position.
# This takes account of gaps in the alignment.
relative_to 8
#
# Set the font for the line that will say alpha1, beta2 etc to Symbol font.
# Region commands operate on a region of the alignment - they usually expect
# four numbers to define the region - the numbers are x,y,x1,y1 where y and y1
# are the sequences and x and x1 are the residue positions.
font_region 1 11 331 11 5
#
#colour all secondary structures black  (colour 11)
# 
colour_text_region 1 10 331 10 11
#
# Now draw all the helices and strands and label and colour them.
#
# For example, Tell ALSCRIPT to draw a strand from 11 to 13 of sequence 10
strand  11  10  13
#  Now write the text b1 (will be a Greek b because of the 
#  font_region command above).
	text 12 11 "b1"
helix   15  10  18
	text 16 11 "a1"
helix   22  10  37
	text 30 11 "a2"
strand  41  10  45
	text 43 11 "b2"
helix   51  10  64
	text 57 11 "a3"
helix   67  10  73
	text 70 11 "a4"
strand  89  10  91
	text 90 11 "b3"
strand 101  10 105
	text 103 11 "b4"
helix  115  10 118
	text 116 11 "a5"
helix  138  10 163
	text 151 11 "a6"
helix  172  10 174
	text 173 11 "a7"
#
#barrel strand 1
strand 183  10 189
#       set the colour to green for this strand.
	colour_text_region 183 10 189 10 10
	text 186 11 "b5"
#
helix  197  10 199
	text 198 11 "a8"
strand 201  10 202
	text 201 11 "b6"
strand 208  10 209
	text 208 11 "b7"
#
#barrel strands 2-6
strand 210  10 214
	text 212 11 "b8"
	colour_text_region 210 10 214 10 10
strand 220  10 225
	text 222 11 "b9"
	colour_text_region 220 10 225 10 10
strand 231  10 235
	text 233 11 "b10"
	colour_text_region 231 10 235 10 10
strand 238  10 241
	text 239 11 "b11"
	colour_text_region 238 10 241 10 10
strand 249  10 253
	text 250 11 "b12"
	colour_text_region 249 10 253 10 10
#
helix  255  10 260
	text 257 11 "a9"
#
#
#barrel strands 7-8
strand 270  10 273
	text 271 11 "b13"
	colour_text_region 270 10 273 10 10
strand 279  10 286
	text 282 11 "b14"
	colour_text_region 279 10 286 10 10
#
#
#
strand 293  10 294
	text 293 11 "b15"
strand 311  10 312
	text 311 11 "b16"
helix  313  10 323
	text 317 11 "a10"
#
#Now add arrows for the residues within 8A of the Mn
#
# The TEXT command normally just writes out the specified text
# at the specified position.  However, special TEXT objects
# exist.  These all start with the @ symbol.
#
colour_text_region 214 12 214 12 1
#
# This draws a filled up arrow at position 214,12.
text 214 12 "@fuparrow"
colour_text_region 216 12 216 12 1
text 216 12 "@fuparrow"
colour_text_region 270 12 270 12 1
text 270 12 "@fuparrow"
colour_text_region 330 12 330 12 1
text 330 12 "@fuparrow"
#
text  41 12 "@fuparrow"
text 252 12 "@fuparrow"
text 221 12 "@fuparrow"
text 187 12 "@fuparrow"
text 285 12 "@fuparrow"
text 223 12 "@fuparrow"
text 272 12 "@fuparrow"
text 218 12 "@fuparrow"
text 231 12 "@fuparrow"
#
#
# Now set the sequence numbering back to alignment positions.
relative_to 0
#
#
# From here to the end of the file was created by the alsnum program
# alsnum creates text commands for numbering a plot relative to a 
# specific sequence, rather than the alignment numbers that are 
# normally shown.  Please see the ALSCRIPT manual for further details.
#
#
# Text commands created for numbering
# Sequence Number: 8
# Starting Number: 1
# Interval:        10
# Position:        9
TEXT 53 9 "10"
TEXT 65 9 "20"
TEXT 78 9 "30"
TEXT 88 9 "40"
TEXT 101 9 "50"
TEXT 111 9 "60"
TEXT 121 9 "70"
TEXT 131 9 "80"
TEXT 141 9 "90"
TEXT 151 9 "100"
TEXT 161 9 "110"
TEXT 171 9 "120"
TEXT 181 9 "130"
TEXT 191 9 "140"
TEXT 201 9 "150"
TEXT 211 9 "160"
TEXT 221 9 "170"
TEXT 231 9 "180"
TEXT 241 9 "190"
TEXT 251 9 "200"
TEXT 261 9 "210"
TEXT 271 9 "220"
TEXT 281 9 "230"
TEXT 297 9 "240"
TEXT 307 9 "250"
TEXT 317 9 "260"
TEXT 327 9 "270"
TEXT 343 9 "280"
TEXT 353 9 "290"
TEXT 363 9 "300"
TEXT 378 9 "310"
TEXT 388 9 "320"
TEXT 398 9 "330"
