# Illustration of ALSCRIPT Command File
#
# As shown in:  Barton, G. J. (1992)
#               ALSCRIPT- A tool to format multiple sequence alignments
# 		Protein Engineering (in press)
#
# Modified version - includes colour commands
#
#
# example 1                    # Comment lines begin with the # symbol
#
#
# (A) Input and output files:
#
BLOCK_FILE    example1.blc             # Define the block file to format
OUTPUT_FILE   example3.ps               # Where to put the result
#
MAX_SIDE     11                         # Fiddle with margins...
Y_OFFSET     50				# This is just to fill the page with the 
X_OFFSET     80				# Alignment.  Defaults normally work OK
#
# (B) Page Layout and overall spacing:
#
ADD_SEQ  38  1                          # Make space after sequence 38
ADD_SEQ  39  3                          # Make space after sequence 39        
ADD_SEQ  69  1
PORTRAIT                                # Portrait paper orientation
POINTSIZE   10                          # 10 point default pointsize
#NUMBER_SEQS  1                          # Set to 1 for numbers at left of plot
IDENT_WIDTH 8
#
# (C) Font definitions:
#
DEFINE_FONT 0 Helvetica      DEFAULT    # Set font 0 to be Helvetica at default pointsize
DEFINE_FONT 1 Helvetica REL  0.75       # Set font 1 to be 0.75 times default Helvetica
DEFINE_FONT 3 Helvetica-Bold DEFAULT    
DEFINE_FONT 4 Times-Bold     DEFAULT   
DEFINE_FONT 5 Helvetica-BoldOblique  DEFAULT 
DEFINE_FONT 6 Times-Roman DEFAULT
#
# COLOUR DEFINITIONS give a colour number, then red, green, blue intensities
#
# red
DEFINE_COLOUR 0 1 0 0
# green
DEFINE_COLOUR 1 0 1 0
# blue
DEFINE_COLOUR 2 0 0 1
# yellow
DEFINE_COLOUR 3 1 1 0
# magenta
DEFINE_COLOUR 4 1 0 1
# cyan
DEFINE_COLOUR 5 0 1 1
#
DEFINE_COLOUR 6 0.7 0.3 0
SETUP                                   # Tell the program to get on with the formatting
#
# (D) Some formatting commands:
#
SURROUND_CHARS LIV   ALL                # Surround all L and Y characters
FONT_CHARS     IV    ALL  5             # Use font 5 for all I and V characters
FONT_CHARS     ASN   ALL  1             # Show A and S and N characters in small caps
FONT_CHARS     KR    ALL  4             # Show K and R in Times-Bold
Ccol_CHARS   LIV   ALL  1
Scol_CHARS   ASN ALL 0
BOX_REGION     14  1  16 38             # Rectangular box of residues 14-16
SHADE_CHARS     +    ALL   0.0          # Shade all + characters black
COLOUR_REGION  14 1 16 38 2
SURROUND_CHARS 56+789  1 40 27 40       # Box numbers and + on line 40
LINE      TOP     2     40     8        # Draw horizontal lines to 
LINE   BOTTOM     2     40     8        # Join up surrounded numbers
TEXT   2      42  "Helix Pattern"            
TEXT   12     42  "Glycine Loop"        # Add text annotations
TEXT   21     42  "Helix Pattern"
SUB_ID        49  "Helix Predictions" 
SUB_ID        58  "Sheet Predictions"   # Change the identifiers for prediction histograms 
SUB_ID        68  "Turn Predictions"
INVERSE_CHARS DE ALL
SHADE_CHARS D ALL 0.5
SHADE_CHARS E ALL 0.0
#
# (E) Now make the prediction histograms nicer.
# 
SURROUND_CHARS  H     1     44     27     53
Scol_CHARS     H     1     44     27     53     3    # Shade the Helix predictions 0.5 grey
SUB_CHARS       1    44     27     53   H SPACE        	# Substitute " " for "H"
#
SURROUND_CHARS  E     1     54     27     63            # Surround the Beta Predictions
Scol_CHARS     E     1     54     27     63     4    # Colour beta blue
SUB_CHARS       1    54     27     63   E SPACE         # Substitute the E for space in the beta predictions
#
SURROUND_CHARS  T     1     64     27     73            # Surround the Turn Predictions
Scol_CHARS     T     1     64     27     73     6    # Shade the Turn Predictions
SUB_CHARS       1    64     27     73   T SPACE         # Substitute the T for space in the turn predictions
#
SUB_ID        75     "Summary Prediction"               # Annotate and shade the summary prediction
SHADE_CHARS    HY     1     75     27     75     0.5
SHADE_CHARS    T      1     75     27     75     0.9
#
#
# Now change the identifier codes
#
ID_FONT ALL 6
SUB_ID 1 "Annexin I H4"
SUB_ID 2 "Annexin I M4"
SUB_ID 3 "Annexin I R4"
SUB_ID 4 "Annexin V R4"
SUB_ID 5 "Annexin V H4"
SUB_ID 6 "Annexin V C4"
SUB_ID 7 "Annexin II H4"
SUB_ID 8 "Annexin II B4"
SUB_ID 9 "Annexin II M4"
SUB_ID 10 "Annexin IV P4"
SUB_ID 11 "Annexin IV B4"
SUB_ID 12 "Annexin IV H4"
SUB_ID 13 "Annexin VI H4"
SUB_ID 14 "Annexin VI M4"
SUB_ID 15 "Annexin VI H8"
SUB_ID 16 "Annexin VI M8"
SUB_ID 17 "Annexin V  BH4"
SUB_ID 18 "Annexin VII 4"
SUB_ID 19 "Annexin III H4"
SUB_ID 20 "Annexin III R4"
SUB_ID 21 "Annexin II M3"
SUB_ID 22 "Annexin II H3"
SUB_ID 23 "Annexin II B3"
SUB_ID 24 "Annexin I H3"
SUB_ID 25 "Annexin I M3"
SUB_ID 26 "Annexin I R3"
SUB_ID 27 "Annexin V C3"
SUB_ID 28 "Annexin V H3"
SUB_ID 29 "Annexin V R3"
SUB_ID 30 "Annexin VI H3"
SUB_ID 31 "Annexin VI M3"
SUB_ID 32 "Annexin IV H3"
SUB_ID 33 "Annexin IV B3"
SUB_ID 34 "Annexin IV P3"
SUB_ID 35 "Annexin V BH3"
SUB_ID 36 "Annexin III H3"
SUB_ID 37 "Annexin III R3"
SUB_ID 38 "Annexin VII 3"
































































